//
//  WXKPhone.h
//  KyoponUtilities2
//
//  Created by FUJIDANA on 06/07/20.
//  Copyright 2006 FUJIDANA. All rights reserved.
//

#import <Foundation/Foundation.h>

#import <termios.h>

//#define kMaxPersonCount					500

//#define kWXKEmailOutboxMaximumNumber		900
//#define kWXKEmailInboxMaximumNumber			900
//#define kWXKLightMailInboxMaximumNumber		100
//#define kWXKLightMailOutboxMaximumNumber	100


typedef enum _WXKPhoneDataType
{
	WXKPhoneAddressDataType = 3,
	WXKPhoneLightMailDataType = 4,
	WXKPhoneEmailDataType = 5,
	WXKPhoneFileDataType = 6,
	WXKPhoneScheduleDataType = 7,
	WXKPhoneBookmarkDataType = 8
} WXKPhoneDataType;


@protocol WXKProgressing;


@interface WXKPhone : NSObject
{
	@private
	int				fileDescriptor;
	struct termios  originalTTYAttrs;
	BOOL			loggedin;
}

+ (BOOL)existsDriver;
+ (NSString *)requiredDriverName;

- (BOOL)receiveAllItemsOfDataType:(WXKPhoneDataType)code intoDataArray:(NSArray **)dataArray withPassword:(NSString *)password progress:(id <WXKProgressing>)progress error:(NSError **)errorPtr;
- (BOOL)writeAllItemsOfDataType:(WXKPhoneDataType)code dataArray:(NSArray *)dataArray withPassword:(NSString *)password progress:(id <WXKProgressing>)progress error:(NSError **)error;

@end
